package ru.yandex.solomon.util.host;

import java.net.Inet6Address;
import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;


/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public interface DnsResolver {
    /**
     * @param fqdn fully qualified host name to resolve
     * @return resolved ipv6 address or null in case of errors
     */
    CompletableFuture<Inet6Address> resolve(String fqdn);
}
