package ru.yandex.solomon.util.host;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Optional;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.base.Strings;

/**
 * @author checat
 */
@ParametersAreNonnullByDefault
public class HostUtils {
    private static final String fqdn;
    private static final String shortName;

    static {
        fqdn = Optional.ofNullable(System.getenv("SOLOMON_FQDN"))
                .map(Strings::emptyToNull)
                .orElseGet(() -> {
                    try {
                        return InetAddress.getLocalHost().getHostName();
                    } catch (UnknownHostException e) {
                        throw new RuntimeException(e);
                    }
                });
        shortName = shortName(fqdn);
    }

    @Nonnull
    public static String getFqdn() {
        return fqdn;
    }

    @Nonnull
    public static String getShortName() {
        return shortName;
    }

    @Nonnull
    public static String shortName(@Nonnull String fqdn) {
        return fqdn.replaceFirst("\\..*", "");
    }

    public static boolean isLocal(String host) {
        return "localhost".equals(host) || fqdn.equals(host);
    }
}
