package ru.yandex.solomon.util.labelStats;

import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;

import ru.yandex.monlib.metrics.labels.Labels;

/**
 * @author Vladimir Gordiychuk
 */
public class LabelStatsCollectors {
    public static Collector<String, LabelStats, LabelStats> toLabelStats() {
        return Collector.of(
                LabelStats::create,
                LabelStats::add,
                (left, right) -> {
                    left.combine(right);
                    return left;
                },
                Function.identity(),
                Collector.Characteristics.IDENTITY_FINISH,
                Collector.Characteristics.UNORDERED);
    }

    public static Collector<Labels, LabelValuesStats, LabelValuesStats> toLabelValuesStats() {
        return toLabelValuesStats(Collections.emptySet());
    }

    public static Collector<Labels, LabelValuesStats, LabelValuesStats> toLabelValuesStats(Set<String> keys) {
        return Collector.of(
                LabelValuesStats::new,
                (stats, labels) -> stats.add(labels, keys),
                (left, right) -> {
                    left.combine(right);
                    return left;
                },
                Function.identity(),
                Collector.Characteristics.IDENTITY_FINISH,
                Collector.Characteristics.UNORDERED);
    }
}
