package ru.yandex.solomon.util.labelStats;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

import ru.yandex.solomon.metabase.api.protobuf.EMetabaseStatusCode;
import ru.yandex.solomon.metabase.api.protobuf.MetricNamesResponse;
import ru.yandex.solomon.metabase.api.protobuf.TLabelValues;
import ru.yandex.solomon.metabase.api.protobuf.TLabelValuesResponse;

/**
 * @author Vladimir Gordiychuk
 */
public class LabelStatsConverter {
    public static TLabelValuesResponse toProto(LabelValuesStats stats) {
        int metricsCount = stats.getMetricsCount();
        return TLabelValuesResponse.newBuilder()
                .setStatus(EMetabaseStatusCode.OK)
                .setMetricCount(stats.getMetricsCount())
                .addAllValues(stats.getStatsByLabelKey().entrySet().stream()
                        .map(entry -> toProto(entry.getKey(), entry.getValue(), metricsCount))
                        .collect(Collectors.toList()))
                .build();
    }

    public static TLabelValues toProto(String name, LabelStats stats, int metricsCount) {
        return TLabelValues.newBuilder()
                .setName(name)
                .setAbsent(stats.getCount() < metricsCount)
                .setTruncated(stats.isTruncated())
                .addAllValues(stats.getValues())
                .setMetricCount(stats.getCount())
                .build();
    }

    public static MetricNamesResponse toProto(LabelStats labelStats) {
        return MetricNamesResponse.newBuilder()
            .setStatus(EMetabaseStatusCode.OK)
            .addAllNames(labelStats.getValues())
            .setTruncated(labelStats.isTruncated())
            .build();
    }

    public static LabelValuesStats fromProto(TLabelValuesResponse proto) {
        Map<String, LabelStats> byKey = new HashMap<>(proto.getValuesCount());
        for (TLabelValues value : proto.getValuesList()) {
            byKey.put(value.getName(), fromProto(value));
        }

        return new LabelValuesStats(byKey, proto.getMetricCount());
    }

    public static LabelStats fromProto(TLabelValues proto) {
        LabelStats stats = LabelStats.create();
        stats.addAll(proto.getValuesList(), proto.getMetricCount(), proto.getTruncated());
        return stats;
    }

    public static LabelStats fromProto(MetricNamesResponse proto) {
        LabelStats stats = LabelStats.create();
        stats.addAll(proto.getNamesList(), 0, proto.getTruncated());
        return stats;
    }
}
