package ru.yandex.solomon.util.lang;

import java.util.stream.IntStream;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class SmallIntToString {
    private static final String[] numberStrings = IntStream.range(0, 10000)
            .mapToObj(Integer::toString).toArray(String[]::new);

    @Nonnull
    public static String toString(int i) {
        if (i >= 0 && i < numberStrings.length) {
            return numberStrings[i];
        } else {
            return Integer.toString(i);
        }
    }

    @Nonnull
    public static String toString(long l) {
        if (l >= 0 && l < numberStrings.length) {
            return numberStrings[(int) l];
        } else {
            return Long.toString(l);
        }
    }
}
