package ru.yandex.solomon.util.mh;

/**
 * @author Stepan Koltsov
 */
public interface MultiArrayResizer<A> {

    void resize(A arrays, int newSize);
    int capacity(A arrays);
    int size(A arrays);

    void reserveAdditional(A arrays, int additional);

    default void reserveAdditionalSimple(A arrays, int additional) {
        int size = size(arrays);
        int capacity = capacity(arrays);
        int minRequiredCapacity = size + additional;
        if (minRequiredCapacity <= capacity) {
            return;
        }

        int newCapacity = MultiArrayResizerCommon.newCapacityImpl(size, capacity, additional);
        resize(arrays, newCapacity);
    }
}
