package ru.yandex.solomon.util.mh;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Objects;

import ru.yandex.misc.lang.IntegerUtils;
import ru.yandex.misc.reflection.ClassX;
import ru.yandex.misc.reflection.FieldX;

/**
 * @author Stepan Koltsov
 */
public class MultiArrayResizerCommon<A> {
    final Class<A> clazz;
    final Field[] arrayFields;
    final Class<?>[] arrayElementTypes;
    final Field capacityField;
    final Field sizeField;

    public MultiArrayResizerCommon(Class<A> clazz) {
        this.clazz = clazz;
        arrayFields = ClassX.wrap(clazz).getAllDeclaredInstanceFieldsAccessible()
            .filter(f -> f.getType().isArray())
            .map(FieldX::getField)
            .toArray(new Field[0]);

        arrayElementTypes = Arrays.stream(arrayFields)
            .map(f -> {
                Class<?> fieldType = f.getType();
                Class<?> componentType = fieldType.getComponentType();
                return Objects.requireNonNull(componentType);
            })
            .toArray(Class[]::new);

        capacityField = arrayFields[0];

        sizeField = ClassX.wrap(clazz).getAllDeclaredInstanceFieldsAccessible()
            .filter(f -> f.hasAnnotation(ArrayListSize.class))
            .map(FieldX::getField)
            .single();

        if (sizeField.getType() != int.class) {
            throw new IllegalArgumentException("class is not integer: " + sizeField.getType().getSimpleName());
        }
    }

    public static int newCapacityImpl(int size, int capacity, int additional) {
        int minRequiredCapacity = Math.addExact(size, additional);

        int nextExpCapacity = IntegerUtils.addSat(capacity, (capacity >> 1));
        return max(nextExpCapacity, minRequiredCapacity, 2);
    }

    private static int max(int a, int b, int c) {
        return Math.max(Math.max(a, b), c);
    }
}
