package ru.yandex.solomon.util.mh;

import java.lang.reflect.Field;
import java.util.Arrays;

import ru.yandex.bolts.type.array.ArrayType;

/**
 * @author Stepan Koltsov
 */
public class MultiArrayResizerRefl<A> implements MultiArrayResizer<A> {

    private final Field[] fields;
    private final ArrayType[] arrayTypes;

    private final Field capacityField;
    private final ArrayType capacityArrayType;

    private final Field sizeField;

    public MultiArrayResizerRefl(Class<A> clazz) {
        MultiArrayResizerCommon<A> common = new MultiArrayResizerCommon<>(clazz);

        fields = common.arrayFields;

        capacityField = common.capacityField;
        capacityArrayType = ArrayType.forArrayClass(capacityField.getType());

        arrayTypes = Arrays.stream(fields)
            .map(f -> ArrayType.forArrayClass(f.getType()))
            .toArray(ArrayType[]::new);

        sizeField = common.sizeField;
    }

    @Override
    public void resize(A arrays, int newSize) {
        try {
            for (int i = 0; i < fields.length; i++) {
                Field field = fields[i];
                Object array = field.get(arrays);
                array = arrayTypes[i].copyOf(array, newSize);
                field.set(arrays, array);
            }
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int capacity(A arrays) {
        try {
            Object array = capacityField.get(arrays);
            return capacityArrayType.length(array);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int size(A arrays) {
        try {
            return (int) sizeField.get(arrays);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void reserveAdditional(A arrays, int additional) {
        reserveAdditionalSimple(arrays, additional);
    }
}
