package ru.yandex.solomon.util.reflect.reified;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class Reified<T, A extends ReifiedToString<T>> {
    private final A object;
    private final Class<T> parameterClass;

    public Reified(A object, Class<T> parameterClass) {
        this.object = object;
        this.parameterClass = parameterClass;
    }

    @Override
    public String toString() {
        try {
            return object.toString(parameterClass);
        } catch (Exception e) {
            return object.toString();
        }
    }
}
