package ru.yandex.solomon.util.text;

import java.util.Comparator;
import java.util.function.Function;

/**
 * @author Maksim Leonov
 */
public class TextComparator {

    public static Comparator<String> compareTextWithNumbers() {
        return new TextWithNumbersComparator();
    }

    public static <A> Comparator<A> comparingTexts(Function<A, String> f) {
        return Comparator.comparing(f, new TextWithNumbersComparator());
    }
}
