package ru.yandex.solomon.util.text;

import java.util.Comparator;

/**
 * @author Stepan Koltsov
 */
public class TextWithNumbersComparator implements Comparator<String> {

    public static final TextWithNumbersComparator instance = new TextWithNumbersComparator();

    @Override
    public int compare(String s1, String s2) {
        return compareImpl(s1, 0, s2, 0);
    }

    private static boolean isAsciiDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static int digitsPrefixLength(String s, int pos) {
        int r = 0;
        while (pos + r < s.length() && isAsciiDigit(s.charAt(pos + r))) {
            ++r;
        }
        return r;
    }

    private static int compareImpl(String s1, int p1, String s2, int p2) {
        while (p1 != s1.length() && p2 != s2.length()) {
            char c1 = s1.charAt(p1);
            char c2 = s2.charAt(p2);
            if (!isAsciiDigit(c1) || !isAsciiDigit(c2)) {
                int charCompare = Character.compare(c1, c2);
                // fast path
                if (charCompare != 0) {
                    return charCompare;
                }

                ++p1;
                ++p2;
                continue;
            }

            int d1Len = Math.min(digitsPrefixLength(s1, p1), 17);
            int d2Len = Math.min(digitsPrefixLength(s2, p2), 17);
            if (d1Len == d2Len) {
                for (int index = 0; index < d1Len; index++) {
                    int charCompare = Character.compare(s1.charAt(p1 + index), s2.charAt(p2 + index));
                    if (charCompare != 0) {
                        return charCompare;
                    }
                }

                p1 += d1Len;
                p2 += d2Len;
                continue;
            }

            // lame
            long d1 = Long.parseLong(s1.substring(p1, p1 + d1Len), 10);
            long d2 = Long.parseLong(s2.substring(p2, p2 + d2Len), 10);
            int numberCompare = Long.compare(d1, d2);
            if (numberCompare != 0) {
                return numberCompare;
            }
            p1 += d1Len;
            p2 += d2Len;
        }

        return Boolean.compare(p1 != s1.length(), p2 != s2.length());
    }
}
