package ru.yandex.solomon.util.time;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

/**
 * @author Stepan Koltsov
 */
public class LocalDateInterval {
    private final LocalDate begin;
    // exclusive
    private final LocalDate end;

    public LocalDateInterval(LocalDate begin, LocalDate end) {
        this.begin = begin;
        this.end = end;
    }

    public LocalDate getBegin() {
        return begin;
    }

    public LocalDate getEnd() {
        return end;
    }

    public LocalDateTimeInterval toLocalDateTimeInterval() {
        return new LocalDateTimeInterval(LocalDateTime.of(begin, LocalTime.MIDNIGHT), LocalDateTime.of(end, LocalTime.MIDNIGHT));
    }
}
