package ru.yandex.solomon.util.time;

import java.time.LocalDateTime;
import java.time.ZoneId;

/**
 * @author Stepan Koltsov
 */
public class LocalDateTimeInterval {
    private final LocalDateTime begin;
    private final LocalDateTime end;

    public LocalDateTimeInterval(LocalDateTime begin, LocalDateTime end) {
        this.begin = begin;
        this.end = end;
    }

    public LocalDateTime getBegin() {
        return begin;
    }

    public LocalDateTime getEnd() {
        return end;
    }

    public Interval toInterval(ZoneId zoneId) {
        return new Interval(begin.atZone(zoneId).toInstant(), end.atZone(zoneId).toInstant());
    }

    public boolean contains(LocalDateTime point) {
        return begin.compareTo(point) <= 0 && point.compareTo(end) < 0;
    }
}
