package ru.yandex.solomon.util.time;

import java.time.Instant;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Maksim Leonov
 */
@ParametersAreNonnullByDefault
public class TimeProviderTestImpl implements TimeProvider {
    private long nowMillis = Instant.parse("2015-10-23T00:00:00.000Z").toEpochMilli();

    public void secondsPassed(long seconds) {
        nowMillis += seconds * 1000;
    }

    public void setTime(Instant instant) {
        this.nowMillis = instant.toEpochMilli();
    }

    @Override
    public long nowMillis() {
        return nowMillis;
    }
}
