package ru.yandex.solomon.util.time;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @author Stepan Koltsov
 */
public class Week {
    private static final DayOfWeek FIRST_DAY_OF_WEEK = DayOfWeek.MONDAY;

    private final LocalDate monday;

    public Week(LocalDate monday) {
        if (monday.getDayOfWeek() != FIRST_DAY_OF_WEEK) {
            throw new RuntimeException("this is not monday: " + monday);
        }
        this.monday = monday;
    }

    public static Week ofDay(LocalDate localDate) {
        return new Week(localDate.minusDays(localDate.getDayOfWeek().getValue() - 1));
    }

    public LocalDate getMonday() {
        return monday;
    }

    public LocalDateTime atStartOfWeek() {
        return getMonday().atStartOfDay();
    }

    public LocalDate getSaturday() {
        return monday.plusDays(5);
    }

    public Week plusWeeks(int weeks) {
        return new Week(monday.plusWeeks(weeks));
    }

    public Week minusWeeks(int weeks) {
        return plusWeeks(-weeks);
    }

    public LocalDateInterval holidaysInterval() {
        return new LocalDateInterval(getSaturday(), plusWeeks(1).getMonday());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Week week = (Week) o;

        if (!monday.equals(week.monday)) return false;

        return true;
    }

    @Override
    public int hashCode() {
        return monday.hashCode();
    }
}
