package ru.yandex.solomon.util.time;

import java.time.ZoneId;
import java.time.ZonedDateTime;

/**
 * @author Stepan Koltsov
 */
public class ZonedDateTimeInterval {
    private final LocalDateTimeInterval localInterval;
    private final ZoneId zoneId;

    public ZonedDateTimeInterval(LocalDateTimeInterval localInterval, ZoneId zoneId) {
        this.localInterval = localInterval;
        this.zoneId = zoneId;
    }

    public ZonedDateTime getBegin() {
        return localInterval.getBegin().atZone(zoneId);
    }

    public ZonedDateTime getEnd() {
        return localInterval.getEnd().atZone(zoneId);
    }

    public LocalDateTimeInterval toLocal() {
        return localInterval;
    }
}
