package ru.yandex.solomon.util.timer;

import ru.yandex.solomon.util.time.InstantUtils;

/**
 * @author Stepan Koltsov
 */
public class OncePerSecondRatePrinter {

    private final long totalCount;
    private long totalSum = 0;
    private long lastInstant = 0;
    private long sumSinceLast = 0;

    public OncePerSecondRatePrinter(long totalCount) {
        this.totalCount = totalCount;
        lastInstant = System.currentTimeMillis();
        sumSinceLast = 0;
    }

    public void add(long delta) {
        this.sumSinceLast += delta;
        long now = System.currentTimeMillis();
        if (now - lastInstant < 1000) {
            return;
        }

        long perSecond = sumSinceLast * 1000 / (now - lastInstant);
        double percent = (double) totalSum * 100 / totalCount;
        System.err.printf("%d/s (%.1f%%)\n", perSecond, percent);
        totalSum += sumSinceLast;
        lastInstant = now;
        sumSinceLast = 0;
    }

    @Override
    public String toString() {
        return "OncePerSecondRatePrinter{" +
            "lastInstant=" + InstantUtils.formatToMillis(lastInstant) +
            ", sumSinceLast=" + sumSinceLast +
            '}';
    }
}
