package ru.yandex.solomon.util.www.ser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author albazh
 */
@ParametersAreNonnullByDefault
public class GggDurationSerializer {

    public static final int SECONDS_PER_MINUTE = 60;
    public static final int SECONDS_PER_HOUR = SECONDS_PER_MINUTE * 60;
    public static final int SECONDS_PER_DAY = SECONDS_PER_HOUR * 24;
    public static final int SECONDS_PER_WEEK = SECONDS_PER_DAY * 7;

    public static class Duration {
        public final int seconds;

        public Duration(int seconds) {
            this.seconds = seconds;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Duration duration = (Duration) o;
            return seconds == duration.seconds;

        }

        @Override
        public int hashCode() {
            return seconds;
        }

        public String formatInSeconds() {
            return formatInSeconds(seconds);
        }

        public static String formatInSeconds(int seconds) {
            return seconds + "s";
        }

        @Override
        public String toString() {
            return formatInSeconds();
        }
    }

    private static final Pattern durationElemPattern = Pattern.compile("^(\\d+)(w|d|h|m|s)");

    @Nullable
    public static Duration parseDuration(@Nullable String duration) {
        if (duration == null || duration.isEmpty()) {
            return null;
        }

        String unparsedDuration = duration.replaceFirst("^-", "");

        if (unparsedDuration.equals("0")) {
            return new Duration(0);
        }

        int sumInSeconds = 0;
        while (unparsedDuration.length() > 0) {
            Matcher matchResult = durationElemPattern.matcher(unparsedDuration);

            if (!matchResult.find()) {
                return null;
            }

            int count = Integer.parseInt(matchResult.group(1));

            switch (matchResult.group(2)) {
                case "w":
                    sumInSeconds += count * SECONDS_PER_WEEK;
                    break;
                case "d":
                    sumInSeconds += count * SECONDS_PER_DAY;
                    break;
                case "h":
                    sumInSeconds += count * SECONDS_PER_HOUR;
                    break;
                case "m":
                    sumInSeconds += count * SECONDS_PER_MINUTE;
                    break;
                case "s":
                    sumInSeconds += count;
                    break;
                default:
                    return null;
            }

            unparsedDuration = unparsedDuration.substring(matchResult.group(0).length());
        }

        return new Duration(sumInSeconds);
    }

}
