package ru.yandex.solomon.util.www.ser;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.OptionalInt;

import javax.annotation.Nullable;

import ru.yandex.solomon.util.time.DurationUtils;

/**
 * @author Stepan Koltsov
 */
public class WwwDurationSerializer {

    public static Optional<Duration> parseDuration(@Nullable String duration) {
        GggDurationSerializer.Duration parsedDuration = GggDurationSerializer.parseDuration(duration);
        return parsedDuration == null
            ? Optional.empty() : Optional.of(Duration.ofSeconds(parsedDuration.seconds));
    }

    public static OptionalInt parseDurationSeconds(@Nullable String duration) {
        GggDurationSerializer.Duration parsedDuration = GggDurationSerializer.parseDuration(duration);
        return parsedDuration == null ? OptionalInt.empty() : OptionalInt.of(parsedDuration.seconds);
    }

    public static String formatDuration(Duration duration) {
        return DurationUtils.formatDuration(duration);
    }

    public static String formatDurationMillis(long millis) {
        return formatDuration(Duration.of(millis, ChronoUnit.MILLIS));
    }

    public static String formatDurationSeconds(long seconds) {
        return formatDurationMillis(DurationUtils.secondsToMillis(seconds));
    }

}
