package ru.yandex.solomon.util;

import org.junit.Test;

import ru.yandex.solomon.util.parser.ParserSupport;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.junit.Assert.assertThat;

/**
 * @author Vladimir Gordiychuk
 */
public class EscaperTest {

    @Test
    public void escapeCharacterNotNecessaryEscape() {
        String source = "test ' \\ something \" aaa!";
        ParserSupport parser = new ParserSupport(source);
        Escaper escaper = new Escaper("\"", '\\');
        String result = escaper.consumeUntil(parser, '.');

        assertThat(result, equalTo(source));
    }

    @Test
    public void parseRegexp() {
        String source = "\\w+";
        ParserSupport parser = new ParserSupport(source);
        Escaper escaper = new Escaper("\"", '\\');
        String result = escaper.consumeUntil(parser, '\'');

        assertThat(result, equalTo(source));
    }
}
