package ru.yandex.solomon.util;

import org.junit.Assert;
import org.junit.Test;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.labels.LabelsBuilder;

/**
 * @author Oleg Baryshnikov
 */
public class MetricNameHelperTest {

    @Test
    public void oldFormat() {
        LabelsBuilder builder = Labels.builder()
            .add("metric", "q1")
            .add("param1", "value1");

        boolean canAdd = MetricNameHelper.canAddMetricNameLabel(builder, "", "");
        Assert.assertFalse(canAdd);
    }

    @Test
    public void newFormat() {
        LabelsBuilder builder = Labels.builder()
            .add("param1", "value1");

        boolean canAdd = MetricNameHelper.canAddMetricNameLabel(builder, "metric", "q1");
        Assert.assertTrue(canAdd);
    }

    @Test(expected = InvalidMetricNameException.class)
    public void duplicatedMetricName() {
        LabelsBuilder builder = Labels.builder()
            .add("metric", "q1")
            .add("param1", "value1");

        MetricNameHelper.canAddMetricNameLabel(builder, "metric", "q1");
    }

    @Test(expected = InvalidMetricNameException.class)
    public void unknownMetricName() {
        LabelsBuilder builder = Labels.builder()
            .add("param1", "value1");

        MetricNameHelper.canAddMetricNameLabel(builder, "metric", "");
    }

    @Test(expected = InvalidMetricNameException.class)
    public void unexpectedMetricName() {
        LabelsBuilder builder = Labels.builder()
            .add("metric", "q1")
            .add("param1", "value1");
        MetricNameHelper.canAddMetricNameLabel(builder, "", "q1");
    }
}
