package ru.yandex.solomon.util;

import java.math.BigInteger;

import org.junit.Assert;
import org.junit.Test;

import ru.yandex.solomon.util.net.NetworkUtils;

/**
 * @author alexlovkov
 */
public class NetworkUtilsTest {

    @Test
    public void networkSize() {
        Assert.assertEquals(BigInteger.ONE, NetworkUtils.getNetworkSize("127.0.0.1"));
        Assert.assertEquals(BigInteger.ONE, NetworkUtils.getNetworkSize("2001:db8:85a3:0:0:8a2e:370:7334"));
        Assert.assertEquals(BigInteger.valueOf(2), NetworkUtils.getNetworkSize("127.5.6.0/30"));
        Assert.assertEquals(BigInteger.valueOf(14), NetworkUtils.getNetworkSize("127.5.6.0/28"));
        Assert.assertEquals(BigInteger.valueOf(6), NetworkUtils.getNetworkSize("2620:10f:d000::/125"));
        Assert.assertEquals(BigInteger.valueOf(254), NetworkUtils.getNetworkSize("2620:10f:d000::/120"));
    }

    @Test(expected = IllegalArgumentException.class)
    public void invalidNetwork() {
        NetworkUtils.getNetworkSize("qwe");
    }
}
