package ru.yandex.solomon.util;

import org.junit.Assert;
import org.junit.Test;

/**
 * @author Sergey Polovko
 */
public class NumbersTest {

    @Test
    public void empty() {
        Assert.assertEquals(10, Numbers.parseIntSafe("", 10));
    }

    @Test
    public void nan() {
        Assert.assertEquals(20, Numbers.parseIntSafe("abc", 20));
    }

    @Test
    public void negative() {
        Assert.assertEquals(-1, Numbers.parseIntSafe("-1", 1));
        Assert.assertEquals(-2, Numbers.parseIntSafe("-2", 1));
    }

    @Test
    public void positive() {
        Assert.assertEquals(0, Numbers.parseIntSafe("0", -1));
        Assert.assertEquals(1, Numbers.parseIntSafe("1", -1));
    }
}
