package ru.yandex.solomon.util;

import java.util.Collections;
import java.util.Set;

import org.junit.Assert;
import org.junit.Test;

import ru.yandex.solomon.util.parser.ParserSupport;

/**
 * @author Oleg Baryshnikov
 */
public class QuoterTest {

    @Test
    public void consumeEmpty() {
        testConsumer("", "");
    }

    @Test
    public void consumeBlank() {
        testConsumer("  ", "");
    }

    @Test
    public void consumeText() {
        testConsumer("value", "value");
    }

    @Test
    public void consumeTextWithWhitespace() {
        testConsumer("value1 value2", "value1");
    }

    @Test
    public void consumeSingleQuotedText() {
        testConsumer("'value1' value2", "value1");
    }

    @Test
    public void consumeDoubleQuotedText() {
        testConsumer("\"value1\" value2", "value1");
    }

    @Test
    public void consumeEscapedAndQuotedText() {
        testConsumer("\"\\\"value1\\\"\" value2", "\"value1\"");
    }

    @Test
    public void consumeTextWithStopSymbols() {
        testConsumer("value1, value2", Collections.singleton(','), "value1");
    }

    @Test
    public void quoteEmpty() {
        Assert.assertEquals("''", Quoter.singleQuote(""));
    }

    @Test
    public void singleQuote() {
        Assert.assertEquals("'value'", Quoter.singleQuote("value"));
    }

    @Test
    public void doubleQuote() {
        Assert.assertEquals("\"value\"", Quoter.doubleQuote("value"));
    }

    @Test
    public void quoteSingleQuotedText() {
        Assert.assertEquals("'\\'value\\''", Quoter.singleQuote("'value'"));
    }

    @Test
    public void quoteDoubleQuotedText() {
        Assert.assertEquals("\"\\\"value\\\"\"", Quoter.doubleQuote("\"value\""));
    }

    private void testConsumer(String source, Set<Character> forbiddenSymbols, String expected) {
        ParserSupport parser = new ParserSupport(source);
        String actual = Quoter.consumeQuotedString(parser, forbiddenSymbols);
        Assert.assertEquals(expected, actual);
    }

    private void testConsumer(String source, String expected) {
        testConsumer(source, Collections.emptySet(), expected);
    }
}
