package ru.yandex.solomon.util;

import org.junit.Assert;
import org.junit.Test;

/**
 * @author Sergey Polovko
 */
public class UrlBuilderTest {

    @Test
    public void oneParam() {
        UrlBuilder builder = new UrlBuilder("http://ya.ru");
        builder.appendQueryArg("key", "value");
        Assert.assertEquals("http://ya.ru?key=value", builder.build());
    }

    @Test
    public void manyParams() {
        UrlBuilder builder = new UrlBuilder("http://ya.ru");
        builder.appendQueryArg("one", "1");
        builder.appendQueryArg("two", "2");
        builder.appendQueryArg("three", "3");
        Assert.assertEquals("http://ya.ru?one=1&two=2&three=3", builder.build());
    }

    @Test
    public void extraParams() {
        UrlBuilder builder = new UrlBuilder("http://ya.ru?one=1");
        builder.appendQueryArg("two", "2");
        builder.appendQueryArg("three", "3");
        Assert.assertEquals("http://ya.ru?one=1&two=2&three=3", builder.build());
    }

    @Test
    public void dropInvalidQuestionMark() {
        UrlBuilder builder = new UrlBuilder("http://ya.ru?");
        builder.appendQueryArg("one", "1");
        builder.appendQueryArg("two", "2");
        builder.appendQueryArg("three", "3");
        Assert.assertEquals("http://ya.ru?one=1&two=2&three=3", builder.build());
    }
}
