package ru.yandex.solomon.util.collection;

import java.util.Map;
import java.util.stream.Stream;

import org.junit.Assert;
import org.junit.Test;

/**
 * @author Stepan Koltsov
 */
public class Collectors2Test {

    @Test
    public void toMapMappingToValue() {
        Map<String, Integer> map = Stream.of("10", "20", "30").collect(Collectors2.toMapMappingToValue(Integer::parseInt));
        Assert.assertEquals(Map.of("10", 10, "20", 20, "30", 30), map);
    }

    @Test
    public void toArray() {
        String[] strings = Stream.of("a", "b", "c").collect(Collectors2.toArray(String[]::new));
        Assert.assertArrayEquals(new String[] { "a", "b", "c" }, strings);
    }

}
