package ru.yandex.solomon.util.collection;

import java.util.Arrays;
import java.util.List;

import org.junit.Assert;
import org.junit.Test;

/**
 * @author Stepan Koltsov
 */
public class GroupByFlatTest {

    @SafeVarargs
    private void testImpl(List<String> input, List<String>... expected) {
        Assert.assertEquals(Arrays.asList(expected), GroupByFlat.groupBy(input, (a, b) -> a.charAt(0) == b.charAt(0)));
    }

    @Test
    public void empty() {
        testImpl(List.of());
    }

    @Test
    public void distinct() {
        testImpl(List.of("a1", "b1", "c1"), List.of("a1"), List.of("b1"), List.of("c1"));
    }

    @Test
    public void altogether() {
        testImpl(List.of("a1", "a2", "a3"), List.of("a1", "a2", "a3"));
    }

    @Test
    public void mixed() {
        testImpl(List.of("a1", "b1", "b2", "c1", "c2", "d1"),
            List.of("a1"),
            List.of("b1", "b2"),
            List.of("c1", "c2"),
            List.of("d1"));
    }

}
