package ru.yandex.solomon.util.collection;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

import org.junit.Assert;
import org.junit.Test;

/**
 * @author Vladimir Gordiychuk
 */
public class NanComparatorTest {

    @Test
    public void nanLast() throws Exception {
        List<Double> source = Arrays.asList(
                0d, 1d, 2d, 3d, 4d, 5d, 6d, 7d, 8d, 9d, 10d,
                Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN
        );
        Collections.shuffle(source);

        double[] result = source.stream()
                .sorted(NanComparator.nanLast(Double::compare))
                .mapToDouble(Double::doubleValue)
                .toArray();

        double[] expected = new double[]{
                0d, 1d, 2d, 3d, 4d, 5d, 6d, 7d, 8d, 9d, 10d,
                Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN
        };
        Assert.assertArrayEquals(expected, result, 0);
    }

    @Test
    public void nanFirst() throws Exception {
        List<Double> source = Arrays.asList(
                0d, 1d, 2d, 3d, 4d, 5d, 6d, 7d, 8d, 9d, 10d,
                Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN
        );
        Collections.shuffle(source);

        double[] result = source.stream()
                .sorted(NanComparator.nanFirst(Double::compare))
                .mapToDouble(Double::doubleValue)
                .toArray();

        double[] expected = new double[]{
                Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN,
                0d, 1d, 2d, 3d, 4d, 5d, 6d, 7d, 8d, 9d, 10d
        };
        Assert.assertArrayEquals(expected, result, 0);
    }

    @Test
    public void nanFirstReversed() throws Exception {
        double[] result = Stream.of(Double.NaN, 5d, 0d, Double.NaN, Double.NaN, 8d, Double.NaN, 10d, 4d, 2d, 8d, Double.NaN)
                .sorted(NanComparator.nanFirst(Double::compare).reversed())
                .mapToDouble(Double::doubleValue)
                .toArray();

        double[] expected = new double[]{10, 8, 8, 5, 4, 2, 0, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN};
        Assert.assertArrayEquals(expected, result, 0);
    }
}
