package ru.yandex.solomon.util.collection;

import org.junit.Test;

import static org.junit.Assert.assertNotSame;
import static org.junit.Assert.assertSame;

/**
 * @author Vladimir Gordiychuk
 */
public class RecyclableLong2ObjectMapTest {

    @Test
    public void getDiffInstance() {
        var first = RecyclableLong2ObjectMap.newInstance();
        var second = RecyclableLong2ObjectMap.newInstance();

        try {
            assertNotSame(first, second);
        } finally {
            first.recycle();
            second.recycle();
        }
    }

    @Test
    public void recycleSame() {
        var first = RecyclableLong2ObjectMap.newInstance();
        first.recycle();

        var second = RecyclableLong2ObjectMap.newInstance();
        try {
            assertSame(first, second);
        } finally {
            second.recycle();
        }
    }
}
