package ru.yandex.solomon.util.collection.array;

import java.util.Arrays;

import org.junit.Assert;
import org.junit.Test;

/**
 * @author Stepan Koltsov
 */
public class ArrayBuilderTest {

    @Test
    public void add() {
        String[] expected = new String[] { "aa", "bb", "cc", "dd", "ee" };

        ArrayBuilder<String> a = new ArrayBuilder<>(new String[0]);

        for (String s : expected) {
            a.add(s);
        }

        Assert.assertArrayEquals(expected, a.build());
    }

    @Test
    public void addAll() {
        String[] expected = new String[] { "aa", "bb", "cc", "dd", "ee" };

        ArrayBuilder<String> a = new ArrayBuilder<>(new String[0]);

        a.addAll(Arrays.copyOf(expected, 3));
        a.addAll(Arrays.copyOfRange(expected, 3, expected.length));

        Assert.assertArrayEquals(expected, a.build());
    }

    @Test
    public void contains() {
        ArrayBuilder<String> a = new ArrayBuilder<>(String.class);
        a.add("a");
        a.add("b");
        a.add("c");
        a.size = 2;
        Assert.assertTrue(a.contains("a"));
        Assert.assertTrue(a.contains("b"));
        Assert.assertFalse(a.contains("c"));
        Assert.assertFalse(a.contains("d"));
    }

    @Test
    public void trimToSize() {
        ArrayBuilder<String> ab = new ArrayBuilder<>(String.class);
        ab.add("a");
        ab.add("b");
        ab.add("c");
        ab.size = 2;
        ab.trimToSize();
        Assert.assertArrayEquals(new String[] { "a", "b" }, ab.array);
    }

}
