package ru.yandex.solomon.util.collection.array;

import org.junit.Assert;
import org.junit.Test;


/**
 * @author Sergey Polovko
 */
public class UnsignedLongArraysTest {

    @Test
    public void binarySearchUnsignedEmpty() {
        long[] a = {};
        Assert.assertTrue(UnsignedLongArrays.binarySearch(a, -1) < 0);
        Assert.assertTrue(UnsignedLongArrays.binarySearch(a, 0) < 0);
        Assert.assertTrue(UnsignedLongArrays.binarySearch(a, 1) < 0);
    }

    @Test
    public void binarySearchUnsignedOne() {
        long[] a = { 0 };
        Assert.assertTrue(UnsignedLongArrays.binarySearch(a, -1) < 0);
        Assert.assertTrue(UnsignedLongArrays.binarySearch(a, 0) == 0);
        Assert.assertTrue(UnsignedLongArrays.binarySearch(a, 1) < 0);

        long[] b = { 1 };
        Assert.assertTrue(UnsignedLongArrays.binarySearch(b, -1) < 0);
        Assert.assertTrue(UnsignedLongArrays.binarySearch(b, 0) < 0);
        Assert.assertTrue(UnsignedLongArrays.binarySearch(b, 1) == 0);

        long[] c = { -1 };
        Assert.assertTrue(UnsignedLongArrays.binarySearch(c, -1) == 0);
        Assert.assertTrue(UnsignedLongArrays.binarySearch(c, 0) < 0);
        Assert.assertTrue(UnsignedLongArrays.binarySearch(c, 1) < 0);
    }

    @Test
    public void binarySearchUnsignedMany() {
        long[] a = { 0, 1337, Long.MAX_VALUE, Long.MIN_VALUE, -1 };
        Assert.assertTrue(UnsignedLongArrays.isSorted(a));

        Assert.assertEquals(0, UnsignedLongArrays.binarySearch(a, 0));
        Assert.assertEquals(1, UnsignedLongArrays.binarySearch(a, 1337));
        Assert.assertEquals(2, UnsignedLongArrays.binarySearch(a, Long.MAX_VALUE));
        Assert.assertEquals(3, UnsignedLongArrays.binarySearch(a, Long.MIN_VALUE));
        Assert.assertEquals(4, UnsignedLongArrays.binarySearch(a, -1));

        Assert.assertTrue(UnsignedLongArrays.binarySearch(a, 1) < 0);
        Assert.assertTrue(UnsignedLongArrays.binarySearch(a, 3) < 0);
        Assert.assertTrue(UnsignedLongArrays.binarySearch(a, 7) < 0);
        Assert.assertTrue(UnsignedLongArrays.binarySearch(a, 11) < 0);
        Assert.assertTrue(UnsignedLongArrays.binarySearch(a, 1336) < 0);
        Assert.assertTrue(UnsignedLongArrays.binarySearch(a, 1338) < 0);
        Assert.assertTrue(UnsignedLongArrays.binarySearch(a, Long.MAX_VALUE - 1) < 0);
        Assert.assertTrue(UnsignedLongArrays.binarySearch(a, Long.MIN_VALUE + 1) < 0);
        Assert.assertTrue(UnsignedLongArrays.binarySearch(a, -2) < 0);
    }
}
