package ru.yandex.solomon.util.collection.enums;

import java.util.EnumSet;
import java.util.Random;

import org.junit.Assert;
import org.junit.Test;

import ru.yandex.misc.random.Random2;

/**
 * @author Stepan Koltsov
 */
public class EnumSetAtomicTest {

    private enum Terrain {
        JUNGLE,
        RIVER,
        HILLS,
    }

    @Test
    public void test() {
        Random r = new Random(888);

        EnumSetAtomic<Terrain> set = EnumSetAtomic.noneOf(Terrain.class);
        EnumSet<Terrain> ref = EnumSet.noneOf(Terrain.class);

        for (int i = 0; i < 10000; ++i) {
            Terrain t = new Random2(r).nextEnum(Terrain.class);
            if (r.nextBoolean()) {
                set.set(t);
                ref.add(t);
            } else {
                set.clear(t);
                ref.remove(t);
            }

            Assert.assertEquals(ref, set.toEnumSet(Terrain.class));
        }
    }

}
