package ru.yandex.solomon.util.collection.queue;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

import org.junit.Assert;
import org.junit.Test;

import ru.yandex.misc.random.Random2;

/**
 * @author Stepan Koltsov
 */
public class ArrayListLockQueueTest {

    @Test
    public void enqueueAllIfSizeLessWithoutOverflow() {
        ArrayListLockQueue<String> queue = new ArrayListLockQueue<>();
        boolean pushed1 = queue.enqueueAllIfSizeLess(Arrays.asList("aa", "bb"), 1);
        Assert.assertTrue(pushed1);
        Assert.assertEquals(Arrays.asList("aa", "bb"), queue.dequeueAll());
    }

    @Test
    public void enqueueAllIfSizeLessWithOverflow() {
        ArrayListLockQueue<String> queue = new ArrayListLockQueue<>();
        boolean pushed1 = queue.enqueueAllIfSizeLess(Arrays.asList("aa", "bb"), 1);
        Assert.assertTrue(pushed1);
        boolean pushed2 = queue.enqueueAllIfSizeLess(Arrays.asList("cc", "dd"), 1);
        Assert.assertFalse(pushed2);
        Assert.assertEquals(Arrays.asList("aa", "bb"), queue.dequeueAll());
    }

    @Test
    public void queueQueueCapacityEstimation() {
        ArrayListLockQueue<Integer> queue = new ArrayListLockQueue<>(10);
        Assert.assertEquals(10, queue.initialCapacity());
        queue.enqueue(777);
        queue.dequeueAll();
        Assert.assertEquals(10, queue.initialCapacity());

        int desiredSize = 100;
        int[] expectedSizes = {15, 22, 33, 49, 73, 109, 109, 109};
        List<Integer> valuesRange = IntStream.range(0, 1000)
            .boxed()
            .collect(Collectors.toList());

        // capacity increased up to first value greater than desired size (e.g. 1.5 * 80)
        for (int expectedSize : expectedSizes) {
            queue.enqueueAll(Random2.R.randomElements(valuesRange, desiredSize));
            queue.dequeueAll();
            Assert.assertEquals(expectedSize, queue.initialCapacity());
        }

        // 80 in [73, 109] interval no initial capacity is not decreased
        queue.enqueueAll(Random2.R.randomElements(valuesRange, 80));
        queue.dequeueAll();
        Assert.assertEquals(109, queue.initialCapacity());

        // decrease capacity by half
        queue.enqueue(777);
        queue.dequeueAll();
        Assert.assertEquals(54, queue.initialCapacity());
    }

    @Test
    public void testSize() {
        var queue = new ArrayListLockQueue<String>();
        System.out.println(queue.size());
        queue.enqueue("test");
        System.out.println(queue.size());
        queue.dequeueAll();
        System.out.println(queue.size());
    }
}
