package ru.yandex.solomon.util.concurrent;

import java.util.Arrays;
import java.util.List;
import java.util.Random;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;


/**
 * @author Sergey Polovko
 */
@RunWith(Parameterized.class)
public class AtomicRandomFieldUpdaterTest {

    @Parameterized.Parameter
    public long seed;

    @Parameterized.Parameters(name = "{0}")
    public static List<Long> data() {
        // first 31 prime numbers
        return Arrays.asList(
            2L, 3L, 5L, 7L, 11L, 13L, 17L, 19L, 23L, 29L, 31L, 37L, 41L, 43L, 47L, 53L, 59L,
            61L, 67L, 71L, 73L, 79L, 83L, 89L, 97L, 101L, 103L, 107L, 109L, 113L, 127L
        );
    }

    static class MyRandom {
        private volatile long value;

        static AtomicRandomFieldUpdater<MyRandom> valueUpdater =
            AtomicRandomFieldUpdater.newUpdater(MyRandom.class, "value");
    }

    private Random random;
    private MyRandom myRandom;


    @Before
    public void setUp() {
        random = new Random(seed);

        myRandom = new MyRandom();
        MyRandom.valueUpdater.setSeed(myRandom, seed);
    }

    @Test
    public void setSeed() {
        int v1 = random.nextInt();
        int v2 = MyRandom.valueUpdater.nextInt(myRandom);

        Assert.assertEquals(v1, v2);
    }

    @Test
    public void nextInt() {
        for (int i = 0; i < 10; i++) {
            int v1 = random.nextInt();
            int v2 = MyRandom.valueUpdater.nextInt(myRandom);

            Assert.assertEquals(v1, v2);
        }
    }

    @Test
    public void nextIntBounded() {
        for (int bound = 10; bound < 1_000_000; bound *= 10) {
            int v1 = random.nextInt(bound);
            int v2 = MyRandom.valueUpdater.nextInt(myRandom, bound);

            Assert.assertEquals(v1, v2);
        }
    }

    @Test
    public void nextLong() {
        for (int i = 0; i < 10; i++) {
            long v1 = random.nextLong();
            long v2 = MyRandom.valueUpdater.nextLong(myRandom);

            Assert.assertEquals(v1, v2);
        }
    }

    @Test
    public void nextBoolean() {
        for (int i = 0; i < 10; i++) {
            boolean v1 = random.nextBoolean();
            boolean v2 = MyRandom.valueUpdater.nextBoolean(myRandom);

            Assert.assertEquals(v1, v2);
        }
    }
}
