package ru.yandex.solomon.util.concurrent;

import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicInteger;

import org.junit.Assert;
import org.junit.Test;

import ru.yandex.misc.test.ForTestSynchronizationUtility;
import ru.yandex.misc.thread.ThreadUtils;
import ru.yandex.solomon.util.ExceptionUtils;

/**
 * @author Stepan Koltsov
 */
public class AutoresetEventTest {

    @Test
    public void tryAwait() {
        AutoresetEvent ev = new AutoresetEvent();

        ForTestSynchronizationUtility u = new ForTestSynchronizationUtility();

        ThreadUtils.spawn(() -> {
            u.take(1);
            ev.signal();
            u.take(2);
        });

        Assert.assertFalse(ev.tryAwait());

        u.take(0);

        u.take(3);

        Assert.assertTrue(ev.tryAwait());
        Assert.assertFalse(ev.tryAwait());
    }

    @Test
    public void await() {

        AutoresetEvent ev = new AutoresetEvent();

        ForTestSynchronizationUtility u = new ForTestSynchronizationUtility();

        ThreadUtils.spawn(() -> {
            u.take(0);
            ev.signal();
        });

        u.take(1);

        ev.await();
    }

    @Test
    public void awaitOnlyOneWakes() throws Exception {
        AutoresetEvent ev = new AutoresetEvent();

        ForTestSynchronizationUtility u = new ForTestSynchronizationUtility();

        AtomicInteger count = new AtomicInteger();

        CyclicBarrier cyclicBarrier = new CyclicBarrier(6);

        for (int i = 0; i < 5; ++i) {
            ThreadUtils.spawn(() -> {
                try {
                    // 1
                    cyclicBarrier.await();

                    // 2
                    cyclicBarrier.await();

                    if (ev.tryAwait()) {
                        System.out.println("inc");
                        count.incrementAndGet();
                    }

                    // 2

                    cyclicBarrier.await();
                } catch (Exception e) {
                    ExceptionUtils.uncaughtException(e);
                }
            });
        }

        // 1
        cyclicBarrier.await();

        ev.signal();

        // 2
        cyclicBarrier.await();

        // 3
        cyclicBarrier.await();

        Assert.assertEquals(1, count.get());
    }

}
