package ru.yandex.solomon.util.concurrent;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

import org.junit.Assert;
import org.junit.Test;

/**
 * @author Stepan Koltsov
 */
public class ForkJoinPoolsTest {

    @Test
    public void name() throws Exception {
        CyclicBarrier b = new CyclicBarrier(5);

        ForkJoinPool fjp = ForkJoinPools.newPool(4, "xx");

        LinkedBlockingQueue<String> namesQueue = new LinkedBlockingQueue<>();

        for (int i = 0; i < 4; ++i) {
            fjp.execute(() -> {
                try {
                    // 1
                    b.await();

                    namesQueue.add(Thread.currentThread().getName());

                    // 2
                    b.await();
                } catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }

        // 1
        b.await();

        // 2
        b.await();

        ArrayList<String> names = new ArrayList<>(namesQueue);
        names.sort(Comparator.naturalOrder());

        Assert.assertEquals(List.of("xx-0", "xx-1", "xx-2", "xx-3"), names);
    }

    @Test
    public void uncaughtException() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> {
            latch.countDown();
        });

        ForkJoinPool pool = ForkJoinPools.newPool(1, "test");
        try {
            pool.execute(() -> {
                throw new RuntimeException("my exception, my rules");
            });
        } finally {
            pool.shutdown();
            Assert.assertTrue(pool.awaitTermination(2, TimeUnit.SECONDS));
        }

        // if exception was not caught by our handler latch will never be count downed
        // and we receive false from its await() method.
        Assert.assertTrue(latch.await(2, TimeUnit.SECONDS));
    }
}
