package ru.yandex.solomon.util.file;

import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

/**
 * @author Stanislav Kashirin
 */
public class SimpleFileStorageTest {

    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();

    @Rule
    public TestName testName = new TestName();

    private ObjectMapper mapper = new ObjectMapper();

    private FileStorage storage;

    @Before
    public void setUp() throws Exception {
        var name = testName.getMethodName();
        var dir = tmp.newFolder(name).toPath();
        storage = new SimpleFileStorage(dir);
    }

    @Test
    public void saveLoad() throws Exception {
        var fileName = fileName();
        var payload = dict();

        storage.save(fileName, payload, mapper::writeValueAsString);
        var loaded = storage.load(fileName, v -> mapper.readValue(v, Map.class));

        assertEquals(payload, loaded);
    }

    @Test
    public void loadOfNothing() throws Exception {
        var fileName = fileName();

        var loaded = storage.load(fileName, v -> mapper.readValue(v, Map.class));

        assertNull(loaded);
    }

    @Test
    public void saveLoadValues() throws Exception {
        var fileName = fileName();
        var payload = List.of(dict(), dict(), dict());

        storage.saveValues(fileName, payload, mapper::writeValueAsString);
        var loaded = storage.loadValues(fileName, v -> mapper.readValue(v, Map.class));

        assertEquals(payload, loaded);
    }

    @Test
    public void loadValuesOfNothing() throws Exception {
        var fileName = fileName();

        var loaded = storage.loadValues(fileName, v -> mapper.readValue(v, Map.class));

        assertNull(loaded);
    }

    private static String fileName() {
        return RandomStringUtils.randomAlphabetic(12);
    }

    private Map<?, ?> dict() {
        return Map.of(
            RandomStringUtils.randomAlphanumeric(16), RandomStringUtils.randomAlphanumeric(16),
            RandomStringUtils.randomAlphanumeric(16), RandomStringUtils.randomAlphanumeric(16));
    }
}
