package ru.yandex.solomon.util.mh;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;

import javax.annotation.Nonnull;

import org.junit.Assert;
import org.junit.Test;

/**
 * @author Stepan Koltsov
 */
public class MultiArrayResizerMhTest extends MultiArrayResizerTestBase {

    @Test
    public void resizePrimitiveField() throws Throwable {
        Field field = Xx.class.getDeclaredField("x");
        field.setAccessible(true);
        MethodHandle mh = MultiArrayResizerMh.makeResizeField(field);
        Xx xx = new Xx();
        mh.invokeExact(xx, 20);
        Assert.assertEquals(20, xx.x.length);
    }

    @Test
    public void resizeStringField() throws Throwable {
        Field field = Xx.class.getDeclaredField("z");
        field.setAccessible(true);
        MethodHandle mh = MultiArrayResizerMh.makeResizeField(field);
        Xx xx = new Xx();
        mh.invokeExact(xx, 20);
        Assert.assertEquals(20, xx.z.length);
    }

    @Test
    public void resizeObjectField() throws Throwable {
        Field field = Xx.class.getDeclaredField("w");
        field.setAccessible(true);
        MethodHandle mh = MultiArrayResizerMh.makeResizeField(field);
        Xx xx = new Xx();
        mh.invokeExact(xx, 20);
        Assert.assertEquals(20, xx.w.length);
    }

    @Test
    public void setAt() throws Throwable {
        MultiArrayResizerMh<Xx> r = new MultiArrayResizerMh<>(Xx.class);
        Xx xx = new Xx();
        r.reserveAdditional(xx, 3);
        r.setAtMhAParam.invokeExact(xx, 1, 4, 5L, "x", new Object());
        Assert.assertEquals(4, xx.x[1]);
        Assert.assertEquals(5L, xx.y[1]);
        Assert.assertEquals("x", xx.z[1]);
    }

    @Test
    public void add() throws Throwable {
        MultiArrayResizerMh<Xx> r = new MultiArrayResizerMh<>(Xx.class);
        Xx xx = new Xx();
        for (int i = 0; i < 100; ++i) {
            r.addMhAParam.invokeExact(xx, i, i + 1L, "x" + i, new Object());
        }

        Assert.assertEquals(100, xx.size);

        for (int i = 0; i < 100; ++i) {
            Assert.assertEquals(i, xx.x[i]);
            Assert.assertEquals(i + 1, xx.y[i]);
            Assert.assertEquals("x" + i, xx.z[i]);
        }
    }

    @Override
    @Nonnull
    public <A> MultiArrayResizer<A> createResizer(Class<A> xxClass) {
        return new MultiArrayResizerMh<>(xxClass);
    }
}
