package ru.yandex.solomon.util.mh;

import javax.annotation.Nonnull;

import org.junit.Assert;
import org.junit.Test;

/**
 * @author Stepan Koltsov
 */
public abstract class MultiArrayResizerTestBase {
    @Nonnull
    public abstract <A> MultiArrayResizer<A> createResizer(Class<A> xxClass);

    @Test
    public void resize() {
        MultiArrayResizer<Xx> resizer = createResizer(Xx.class);
        Xx xx = new Xx();
        resizer.resize(xx, 13);
        Assert.assertEquals(13, xx.x.length);
        Assert.assertEquals(13, xx.y.length);
        Assert.assertEquals(13, xx.z.length);
        Assert.assertEquals(13, xx.w.length);
    }

    @Test
    public void capacity() {
        Assert.assertEquals(10, createResizer(Xx.class).capacity(new Xx()));
    }

    @Test
    public void size() {
        Xx xx = new Xx();
        xx.size = 3;
        Assert.assertEquals(3, createResizer(Xx.class).size(xx));
    }

    @Test
    public void reserveAdditionalNoResize() {
        MultiArrayResizer<Xx> resizer = createResizer(Xx.class);
        Xx xx = new Xx();
        resizer.reserveAdditional(xx, 3);
        Assert.assertEquals(10, xx.x.length);
    }

    @Test
    public void reserveAdditionalResize() {
        MultiArrayResizer<Xx> resizer = createResizer(Xx.class);
        Xx xx = new Xx();
        resizer.reserveAdditional(xx, 50);
        Assert.assertEquals(50, xx.x.length);
        Assert.assertEquals(50, xx.y.length);
        Assert.assertEquals(50, xx.z.length);
        Assert.assertEquals(50, xx.w.length);
    }

    public static class Xx {
        int[] x = new int[10];
        long[] y = new long[10];
        String[] z = new String[10];
        Object[] w = new Object[10];

        @ArrayListSize
        int size = 0;
    }
}
