package ru.yandex.solomon.util.parser;

import java.util.function.Consumer;

import org.junit.Assert;
import org.junit.Test;

/**
 * @author Stepan Koltsov
 */
public class ParserSupportTest {

    private void testWhole(String s, Consumer<ParserSupport> callback) {
        ParserSupport parser = new ParserSupport(s);
        callback.accept(parser);
        parser.checkEof();
    }

    @Test
    public void decimal() {
        testWhole("1020", parser -> {
            Assert.assertEquals(1020, parser.nextUnsignedIntDecimal());
        });
    }

}
