package ru.yandex.solomon.util.protobuf;

import com.google.protobuf.ByteString;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import org.junit.Assert;
import org.junit.Test;

/**
 * @author Sergey Polovko
 */
public class Lz4CodecTest {

    @Test
    public void encodeDecode() {
        var original = Unpooled.copiedBuffer("The quick brown fox jumps over the lazy dog", CharsetUtil.UTF_8);

        int readerIndexBefore = original.readerIndex();
        int writerIndexBefore = original.writerIndex();

        ByteString encoded = Lz4Codec.encode(original);
        Assert.assertFalse(encoded.isEmpty());

        // indexes must not be changed
        Assert.assertEquals(readerIndexBefore, original.readerIndex());
        Assert.assertEquals(writerIndexBefore, original.writerIndex());

        var chewed = Lz4Codec.decode(encoded, original.readableBytes());
        Assert.assertEquals(original, chewed);
    }
}
