package ru.yandex.solomon.util.text;

import org.junit.Assert;
import org.junit.Test;

import ru.yandex.solomon.util.concurrent.ThreadUtils;

/**
 * @author Stepan Koltsov
 */
public class TextComparatorTest {

    private void testLess(String a, String b) {
        Assert.assertEquals(-1, TextComparator.compareTextWithNumbers().compare(a, b));
        Assert.assertEquals(1, TextComparator.compareTextWithNumbers().compare(b, a));
    }

    @Test
    public void handPicked() {
        testLess("", "a");
        testLess("", "11");
        testLess("a2", "a11");
        testLess("a2xx", "a11xx");
        testLess("a2xx", "a2xxy");
        testLess("a2xx10", "a2xx22");
        testLess("a2xx10", "a2xx22x");
    }

    @Test
    public void randomEqual() {
        String charset = "abcdefghiklm01234567890";
        for (int i = 0; i < 10000; ++i) {
            int len = ThreadUtils.currentThreadLocalRandom().nextInt(10);
            StringBuilder sb = new StringBuilder(len);
            for (int j = 0; j < len; ++j) {
                sb.append(charset.charAt(ThreadUtils.currentThreadLocalRandom().nextInt(charset.length())));
            }
            String s = sb.toString();
            Assert.assertEquals(0,TextComparator.compareTextWithNumbers().compare(s, s));
        }
    }

}
