package ru.yandex.solomon.util.text;

import org.junit.Test;

import static org.hamcrest.number.OrderingComparison.greaterThan;
import static org.hamcrest.number.OrderingComparison.lessThan;
import static org.junit.Assert.assertThat;

/**
 * @author Vladimir Gordiychuk
 */
public class TextWithNumbersComparatorTest {

    @Test
    public void alertIdCompare() {
        String a = "9e2a85e06fd214c18ffb4ea146389b9fb2061fa3";
        String b = "15f15a419f873490ce5c5e6ce651e10920a0acff";
        String c = "4265427724080393024270779296d40304f6605e";

        test(a, b, c);
    }

    @Test
    public void binMs() {
        test("1ms", "2ms", "10ms");
        test("10 ms", "50 ms", "100 ms");
    }

    @Test
    public void text() {
        test("a", "b", "c");
        test("aa", "bb", "cc");
    }

    @Test
    public void number() {
        test("10", "50","100");
    }

    @Test
    public void partNum() {
        test(">10ms", ">50ms", ">100ms");
    }

    private void test(String a, String b, String c) {
        assertThat(compare(a, b), lessThan(0));
        assertThat(compare(b, a), greaterThan(0));

        assertThat(compare(b, c), lessThan(0));
        assertThat(compare(c, b), greaterThan(0));

        assertThat(compare(a, c), lessThan(0));
        assertThat(compare(c, a), greaterThan(0));
    }

    private int compare(String left, String right) {
        return TextWithNumbersComparator.instance.compare(left, right);
    }
}
