package ru.yandex.solomon.util.time;

import java.time.Instant;

import org.junit.Assert;
import org.junit.Test;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static ru.yandex.solomon.util.time.InstantUtils.checkGridMultiplicity;

/**
 * @author Stepan Koltsov
 */
public class InstantUtilsTest {

    @Test
    public void format() {
        Assert.assertEquals("2015-04-15T13:14:15.123Z",
                InstantUtils.toMillisFormatter.format(Instant.parse("2015-04-15T13:14:15.123456789Z")));
        Assert.assertEquals("2015-04-15T13:14:15.000Z",
                InstantUtils.toMillisFormatter.format(Instant.parse("2015-04-15T13:14:15.000000000Z")));
        Assert.assertEquals("2015-04-15T13:14:15Z",
                InstantUtils.toSecondsFormatter.format(Instant.parse("2015-04-15T13:14:15.000000000Z")));
    }

    @Test
    public void gridMultiplicity() {
        for (int index = 1; index < 7; index++) {
            assertTrue("300 % " + index, checkGridMultiplicity(300, index));
            assertTrue("300 % " + index, checkGridMultiplicity(index, 300));
        }
        for (int index = 7; index < 10; index++) {
            assertFalse("300 % " + index, checkGridMultiplicity(index, 300));
            assertFalse("300 % " + index, checkGridMultiplicity(300, index));
        }
        assertTrue(checkGridMultiplicity(300, 300));
        assertFalse(checkGridMultiplicity(300, 299));
        assertFalse(checkGridMultiplicity(300, 301));
    }
}
