JAVA_LIBRARY(util)

OWNER(g:solomon)

INCLUDE(${ARCADIA_ROOT}/solomon/libs/java/jdk.inc)

JAVA_SRCS(
    PACKAGE_PREFIX ru.yandex.solomon.util
    SRCDIR src
    **/*.java
    **/*.txt
)

INCLUDE(${ARCADIA_ROOT}/solomon/libs/java/contribs.inc)

PEERDIR(
    # logging
    contrib/java/org/slf4j/slf4j-api

    # iceberg deps
    iceberg/bolts
    iceberg/commune-mh
    iceberg/misc
    iceberg/misc-local-actors

    # other deps
    contrib/java/com/google/guava/guava
    contrib/java/org/apache/commons/commons-lang3
    contrib/java/it/unimi/dsi/fastutil
    contrib/java/org/objenesis/objenesis/2.4
    contrib/java/io/netty/netty-all
    contrib/java/com/github/jgonian/commons-ip-math/1.32

    # TODO: move HttpUtils with this dependency into separate library
    contrib/java/org/springframework/spring-web

    solomon/protos/common
    solomon/protos/metabase
    library/java/monlib/metrics
    solomon/libs/java/memory-layout

    iceberg/commune-protobuf
    contrib/java/com/fasterxml/jackson/core/jackson-core
    contrib/java/com/fasterxml/jackson/core/jackson-databind
    contrib/java/com/fasterxml/jackson/core/jackson-annotations
)

LINT(base)
END()

RECURSE(benchmark)
RECURSE_FOR_TESTS(ut)
