package ru.yandex.abc;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import ru.yandex.abc.dto.AbcMember;
import ru.yandex.abc.dto.AbcService;
import ru.yandex.abc.dto.AbcServiceDuty;
import ru.yandex.abc.dto.AbcServiceDuty2;

/**
 * @author Sergey Polovko
 */
public interface AbcClient {

    CompletableFuture<Optional<AbcService>> getService(String slug);
    CompletableFuture<List<AbcServiceDuty>> getServiceDuty(String slug);
    CompletableFuture<Optional<AbcServiceDuty2>> getDutyVersion2(String slug);
    CompletableFuture<List<AbcMember>> getServiceMembers(String slug, String roleScopeSlug);
}
