package ru.yandex.abc.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;


/**
 * @author snoop
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class AbcService {

    private final long id;
    private final String slug;
    private final String state;

    @JsonCreator
    public AbcService(
        @JsonProperty("id") long id,
        @JsonProperty("slug") String slug,
        @JsonProperty("state") String state)
    {
        this.id = id;
        this.slug = slug;
        this.state = state;
    }

    public long getId() {
        return id;
    }

    public String getSlug() {
        return slug;
    }

    public String getState() {
        return state;
    }

    @Override
    public String toString() {
        return "Service{id=" + id + ", slug='" + slug + "', state='" + state + "'}";
    }
}
