package ru.yandex.abc;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

import com.google.common.io.Resources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockserver.junit.MockServerRule;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;

import static ru.yandex.misc.concurrent.CompletableFutures.join;

/**
 * @author Sergey Polovko
 */
public class HttpAbcClientTest {
    private AbcClient client;
    private Executor executor;
    @Rule
    public final MockServerRule mockServerRule = new MockServerRule(this);

    @Before
    public void setUp() {
        executor = Executors.newFixedThreadPool(2);
        client = new HttpAbcClient(AbcClientOptions.newBuilder()
                .setUrl("http://localhost:" + mockServerRule.getPort())
                .setHandlerExecutor(executor)
                .build());
    }

    @Test
    public void getService() {
        mockServerRule.getClient()
                .when(HttpRequest.request()
                        .withMethod("GET")
                        .withPath("/api/v4/services/")
                        .withQueryStringParameter("slug", "solomon")
                        .withHeader("Accept", "application/json"))
                .respond(HttpResponse.response(load("solomon_service.json")));

        var service = join(client.getService("solomon"));
        Assert.assertTrue(service.isPresent());
        Assert.assertEquals(700L, service.get().getId());
        Assert.assertEquals("solomon", service.get().getSlug());
        Assert.assertEquals("develop", service.get().getState());
    }

    private static String load(String res) {
        try {
            URL url = HttpAbcClientTest.class.getResource(res);
            return Resources.toString(url, StandardCharsets.UTF_8);
        } catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}
