package ru.yandex.ambry;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.ambry.dto.LastUpdatedResponse;
import ru.yandex.ambry.dto.YasmAlertDto;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public interface AmbryClient {

    enum TagFormat {
        DYNAMIC,
        NAMED,
        DICT
    }

    CompletableFuture<List<YasmAlertDto>> list(TagFormat tagFormat, int limit, int offset);

    default CompletableFuture<List<YasmAlertDto>> list(TagFormat tagFormat) {
        return list(tagFormat, -1, 0);
    }

    CompletableFuture<LastUpdatedResponse> lastUpdatedTotal();

}
