package ru.yandex.ambry;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class AmbryException extends RuntimeException {
    private final String endpoint;
    private final String status;

    public AmbryException(String endpoint, String status) {
        super("Call to " + endpoint + " failed with status: " + status);
        this.endpoint = endpoint;
        this.status = status;
    }
}
